/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class CylinderShinglesGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        int i;
        Thread.currentThread().setPriority(1);
        int radius = Integer.parseInt(args[0]);
        int slices = Integer.parseInt(args[1]);
        int height = Integer.parseInt(args[2]);
        boolean adjustForOverlappingCylinderCuts = Boolean.valueOf(args[3]);
        int shinglesType = Integer.parseInt(args[4]);
        Point3D[] curve = CylinderShinglesGenerator.generatePipeCurve(radius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        AxisRotation3D rot = new AxisRotation3D(1, 1.5707963267948966);
        for (i = 0; i <= slices; ++i) {
            curve[i] = rot.transform(curve[i]);
        }
        CylinderShinglesGenerator.startMap();
        if (shinglesType == 1) {
            CylinderShinglesGenerator.writeBrushExtendZ(-height, curve[0], new Point3D(curve[0].x - 1.0, curve[0].y, curve[0].z), new Point3D(curve[1].x - 1.0, curve[1].y, curve[1].z), curve[1]);
            for (i = 1; i < slices; ++i) {
                if (curve[i].y >= curve[i + 1].y) continue;
                CylinderShinglesGenerator.writeBrushExtendZ(-height, curve[i], new Point3D(curve[i + 1].x - 1.0, curve[i + 1].y, curve[i + 1].z), curve[i + 1], false);
            }
        } else if (shinglesType == 2) {
            for (i = 0; i < slices; ++i) {
                if (curve[i].y >= curve[i + 1].y) continue;
                CylinderShinglesGenerator.writeBrushExtendZ(-height, curve[i], new Point3D(curve[i + 1].x - 1.0, curve[i + 1].y, curve[i + 1].z), curve[i + 1], false);
            }
        } else {
            for (i = 0; i < slices / 2; ++i) {
                CylinderShinglesGenerator.writeBrushExtendZ(-height, curve[i], new Point3D(curve[i + 1].x - 1.0, curve[i + 1].y, curve[i + 1].z), curve[i + 1], false);
            }
            for (i = slices / 2; i < slices; ++i) {
                CylinderShinglesGenerator.writeBrushExtendZ(-height, curve[i], new Point3D(curve[i + 1].x, curve[i + 1].y - 1.0, curve[i + 1].z), curve[i + 1], false);
            }
        }
        CylinderShinglesGenerator.endMap();
    }
}

