/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;

public class ExtrudeRadiusFactorCalculator {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int radius = Integer.parseInt(args[0]);
        int slices = Integer.parseInt(args[1]);
        int extrudeTopNSlices = Integer.parseInt(args[2]);
        int lipOffset = Integer.parseInt(args[3]);
        Point3D pt0 = new Point3D(radius, 0.0, 0.0);
        AxisRotation3D rot = new AxisRotation3D(2, Math.PI * (double)extrudeTopNSlices / (double)(2 * slices));
        pt0 = rot.transform(pt0);
        Point3D pt1 = new Point3D(radius + lipOffset, 0.0, 0.0);
        Point3D pt2 = new Point3D(pt0.x - pt0.z, pt0.y, pt0.z + pt0.x);
        double a = Math.sqrt((pt0.x - pt1.x) * (pt0.x - pt1.x) + (pt0.z - pt1.z) * (pt0.z - pt1.z));
        double c = Math.sqrt((pt1.x - pt2.x) * (pt1.x - pt2.x) + (pt1.z - pt2.z) * (pt1.z - pt2.z));
        double b = Math.sqrt((pt2.x - pt0.x) * (pt2.x - pt0.x) + (pt2.z - pt0.z) * (pt2.z - pt0.z));
        double cosAlpha = (a * a + b * b - c * c) / (2.0 * a * b);
        double alpha = Math.acos(cosAlpha);
        double sinAlpha = Math.sin(alpha);
        double newRadius = a / (2.0 * sinAlpha);
        System.out.println("extrudeRadiusFactor: " + newRadius / (double)radius);
    }

    public static double calculate(String[] args) {
        Thread.currentThread().setPriority(1);
        int radius = Integer.parseInt(args[0]);
        int slices = Integer.parseInt(args[1]);
        int extrudeTopNSlices = Integer.parseInt(args[2]);
        int lipOffset = Integer.parseInt(args[3]);
        Point3D pt0 = new Point3D(radius, 0.0, 0.0);
        AxisRotation3D rot = new AxisRotation3D(2, Math.PI * (double)extrudeTopNSlices / (double)(2 * slices));
        pt0 = rot.transform(pt0);
        Point3D pt1 = new Point3D(radius + lipOffset, 0.0, 0.0);
        Point3D pt2 = new Point3D(pt0.x - pt0.z, pt0.y, pt0.z + pt0.x);
        double a = Math.sqrt((pt0.x - pt1.x) * (pt0.x - pt1.x) + (pt0.z - pt1.z) * (pt0.z - pt1.z));
        double c = Math.sqrt((pt1.x - pt2.x) * (pt1.x - pt2.x) + (pt1.z - pt2.z) * (pt1.z - pt2.z));
        double b = Math.sqrt((pt2.x - pt0.x) * (pt2.x - pt0.x) + (pt2.z - pt0.z) * (pt2.z - pt0.z));
        double cosAlpha = (a * a + b * b - c * c) / (2.0 * a * b);
        double alpha = Math.acos(cosAlpha);
        double sinAlpha = Math.sin(alpha);
        double newRadius = a / (2.0 * sinAlpha);
        return newRadius / (double)radius;
    }
}

