/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class OffsetCylinderGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        int i;
        Thread.currentThread().setPriority(1);
        int outerRadius = Integer.parseInt(args[0]);
        int innerRadius = Integer.parseInt(args[1]);
        int slices = Integer.parseInt(args[2]);
        int height = Integer.parseInt(args[3]);
        boolean overlappingBrushes = Boolean.valueOf(args[4]);
        boolean generateOnlySeam = Boolean.valueOf(args[5]);
        boolean adjustSeamForJoining = Boolean.valueOf(args[6]);
        Point3D[] outerCurve = new Point3D[slices + 1];
        Point3D[] innerCurve = new Point3D[slices + 1];
        Point3D ptOuter = new Point3D(outerRadius, 0.0, 0.0);
        Point3D ptInner = new Point3D(innerRadius, 0.0, 0.0);
        double offsetRadians = Math.PI / (double)(4 * slices);
        for (i = 0; i <= slices; ++i) {
            AxisRotation3D rot = new AxisRotation3D(4, offsetRadians + Math.PI * (double)i / (double)(2 * slices));
            outerCurve[i] = rot.transform(ptOuter);
            innerCurve[i] = rot.transform(ptInner);
        }
        if (adjustSeamForJoining) {
            outerCurve[slices] = new Point3D(0.0, outerRadius, 0.0);
            innerCurve[slices] = new Point3D(0.0, innerRadius, 0.0);
        }
        OffsetCylinderGenerator.startMap();
        for (i = 0; i < slices; ++i) {
            Point3D pt3;
            Point3D pt2;
            if (generateOnlySeam && i != slices - 1) continue;
            if ((double)innerRadius == 0.0) {
                OffsetCylinderGenerator.writeBrushExtendZ(-height, outerCurve[i], innerCurve[i], outerCurve[i + 1], false);
                continue;
            }
            Point3D pt1 = outerCurve[i];
            Point3D pt4 = outerCurve[i + 1];
            if (!overlappingBrushes) {
                pt2 = innerCurve[i];
                pt3 = innerCurve[i + 1];
            } else {
                double pt2x = Math.round(innerCurve[i].x);
                double pt2y = Math.round(innerCurve[i].y);
                double pt3x = Math.round(innerCurve[i + 1].x);
                double pt3y = Math.round(innerCurve[i + 1].y);
                double z = innerCurve[i].z;
                pt2 = new Point3D(pt2x + (pt2x - pt3x), pt2y + (pt2y - pt3y), z);
                pt3 = new Point3D(pt3x + (pt3x - pt2x), pt3y + (pt3y - pt2y), z);
            }
            OffsetCylinderGenerator.writeBrushExtendZ(-height, pt1, pt2, pt3, pt4);
        }
        OffsetCylinderGenerator.endMap();
    }
}

